
		include	ht66f2370.inc
					
LCMRS				EQU	PH.0
LCMRES			EQU	PH.1
LCMCSN			EQU	PE.0
LCMSDA			EQU	PE.1
LCMSCK			EQU	PE.3

DSP_NORMAL		EQU	0
DSP_INVERT		EQU	1
DSP_CURSOR		EQU	2
DSP_CLEAR		EQU	3	
;-------------------------------------------------------------------------;				
@LCM_data		.section 'data'
LCMtmp0			db		?
LCMtmp1			db		?
LCMtmp2			db		?
LCMtmp3			db		?

		extern	FONT6X8:NEAR
		extern	FONT8X8:NEAR
		extern	BCLOGO:NEAR
;-------------------------------------------------------------------------;
@LCM_code		.section 'code'
;-------------------------------------------------------------------------;
;void LCM_InterfaceConfigure(void)
;-------------------------------------------------------------------------;
		public	_LCM_InterfaceConfigure
_LCM_InterfaceConfigure	proc
		mov		A,0F0H
		landm		A,PHS0						;PH0/PH1 to IO
		mov		A,11111100B
		landm		A,PES0
		mov		A,11001100B
		lorm		A,PES0						;PE0/PE1/PE3 to SPI
		mov		A,0FCH
		andm		A,PHC							;PH0/PH1 to output mode 
		mov		A,11110100B
		andm		A,PEC							;PE0/PE1/PE3 to output mode
		mov		A,00001011B
		orm		A,PEPU						;PE0/PE1/PE3 pull-high
		mov		A,00000000B
		mov		SPIAC0,A
		mov		A,00001000B
		mov		SPIAC1,A
		set		LCMRS
		set		LCMCSN
		set		SPIAEN
		ret
_LCM_InterfaceConfigure	endp
;-------------------------------------------------------------------------;
;void LCM_Initialize(void)
;-------------------------------------------------------------------------;
		public	_LCM_Initialize
_LCM_Initialize	proc
		;reset LCM
		clr		LCMRES
		mov		A,10
		call		LCM_delay			;delay 20us
		set		LCMRES
		clr		ACC
		call		LCM_delay			;delay 500us
		call		LCM_delay			;delay 500us
		call		LCM_delay			;delay 500us
		call		LCM_delay			;delay 500us
		call		LCM_delay			;delay 500us
		call		LCM_delay			;delay 500us
		mov		A,0A0H				;seg1-seg128
		call		LCM_write_cmd		
		mov		A,0C8H				;com64-com1
		call		LCM_write_cmd
		mov		A,0A2H				;bias = 1/9
		call		LCM_write_cmd
		mov		A,02CH				;Booster circuit: ON
		call		LCM_write_cmd
		mov		A,50
		call		LCM_delay			;delay 100us
		mov		A,02EH
		call		LCM_write_cmd
		mov		A,50
		call		LCM_delay			;delay 100us
		;Voltage follower circuit: ON
		mov		A,02FH
		call		LCM_write_cmd
		mov		A,024H
		call		LCM_write_cmd
		;set electronic volume
		mov		A,081H
		call		LCM_write_cmd
		mov		A,01AH
		call		LCM_write_cmd
		mov		A,50
		call		LCM_delay			;delay 100us
		;display on
		mov		A,0AFH
		call		LCM_write_cmd
		;enable Icon
		mov		A,040H
		call		LCM_write_cmd
		ret				
_LCM_Initialize	endp
;-------------------------------------------------------------------------;
;void LCM_BCLogo(void)
;-------------------------------------------------------------------------;
		public	_LCM_BCLogo
_LCM_BCLogo		proc
		mov		A,8
		mov		MP2L,A
		mov		A,LOW(BCLOGO)
		mov		TBLP,A
		mov		A,HIGH(BCLOGO)
		mov		TBHP,A
LCM_Logo_Loop:		
		clr		LCMtmp0
		mov		A,8
		sub		A,MP2L
		call		LCM_set_position
		mov		A,128/2
		mov		LCMtmp0,A
		mov		A,DSP_NORMAL
		call		LCM_write_block_data
		sdz		MP2L
		jmp		LCM_Logo_Loop
		ret		
_LCM_BCLogo		endp
;-------------------------------------------------------------------------;
;void LCM_Clear(void)
;-------------------------------------------------------------------------;
		public	_LCM_Clear
_LCM_Clear		proc
		mov		A,8
		mov		MP2L,A
LCM_Clear_Loop:		
		clr		LCMtmp0
		mov		A,8
		sub		A,MP2L
		call		LCM_set_position
		mov		A,128/2
		mov		LCMtmp0,A
		mov		A,DSP_CLEAR
		call		LCM_write_block_data
		sdz		MP2L
		jmp		LCM_Clear_Loop
		ret
_LCM_Clear		endp
;-------------------------------------------------------------------------;
;void LCM_LineClear(u8 row)
;-------------------------------------------------------------------------;
		public	_LCM_LineClear
_LCM_LineClear	proc
		clr		LCMtmp0
		and		A,007H		
		call		LCM_set_position
		mov		A,128/2
		mov		LCMtmp0,A
		mov		A,DSP_CLEAR
		jmp		LCM_write_block_data
		ret
_LCM_LineClear	endp
;-------------------------------------------------------------------------;
;void LCM_PutChar6(char val,u8 row,u8 col,u8 invt)
;-------------------------------------------------------------------------;
		public	_LCM_PutChar6
		public	_LCM_PutChar6_2
_LCM_PutChar6	proc
		local		_LCM_PutChar6_2	db 4 dup(?)
		mov		_LCM_PutChar6_2[3],A
		;set position
		mov		A,_LCM_PutChar6_2[1]
		mov		LCMtmp0,A
		mov		A,_LCM_PutChar6_2[0]
		call		LCM6X8_position
		;put char
		mov		A,_LCM_PutChar6_2[2]
		mov		LCMtmp1,A		
		mov		A,_LCM_PutChar6_2[3]
		jmp		put6x8_block_data
		ret
_LCM_PutChar6	endp
;-------------------------------------------------------------------------;
;void LCM_PutString6(u8 *p,u8 row,u8 col,u8 invt)
;-------------------------------------------------------------------------;
		public	_LCM_PutString6
		public	_LCM_PutString6_2
_LCM_PutString6	proc
		local		_LCM_PutString6_2	db 5 dup(?)
		;set position
		mov		A,_LCM_PutString6_2[3]
		mov		LCMtmp0,A
		mov		A,_LCM_PutString6_2[2]
		call		LCM6X8_position
		mov		A,_LCM_PutString6_2[0]
		mov		MP2L,A
		mov		A,_LCM_PutString6_2[1]
		mov		MP2H,A
		mov		A,_LCM_PutString6_2[4]
		mov		LCMtmp1,A
put6x8_strLoop:
		snz		IAR2
		ret
		mov		A,IAR2
		call		put6x8_block_data
		siz		MP2L
		jmp		put6x8_strLoop
		inc		MP2H
		jmp		put6x8_strLoop						
		ret
_LCM_PutString6	endp
;-------------------------------------------------------------------------;
;void LCM_ConstString6(uc8 *p,u8 row,u8 col,u8 invt)
;-------------------------------------------------------------------------;
		public	_LCM_ConstString6
		public	_LCM_ConstString6_2
_LCM_ConstString6	proc
		local		_LCM_ConstString6_2	db 5 dup(?)
		;set position
		mov		A,_LCM_ConstString6_2[3]
		mov		LCMtmp0,A
		mov		A,_LCM_ConstString6_2[2]
		call		LCM6X8_position
		mov		A,_LCM_ConstString6_2[0]
		mov		MP2L,A
		mov		A,_LCM_ConstString6_2[1]
		mov		MP2H,A
		clr		_LCM_ConstString6_2[2].0
		snz		ACC.7
		jmp		$+7
		sz			_LCM_ConstString6_2[0].0
		set		_LCM_ConstString6_2[2].0
		rrc		MP2H
		rrc		MP2L
		mov		A,03FH
		andm		A,MP2H		
		mov		A,_LCM_ConstString6_2[4]
		mov		LCMtmp1,A
const6x8_strLoop:
		mov		A,MP2L
		mov		TBLP,A
		mov		A,MP2H
		mov		TBHP,A
		TABRDC	MP1L
		mov		A,TBLH
		mov		MP1H,A
		sz			_LCM_ConstString6_2[2].0
		jmp		$+5
		snz		MP1L
		ret
		mov		A,MP1L
		call		put6x8_block_data
		snz		MP1H
		ret
		mov		A,MP1H
		call		put6x8_block_data
		clr		_LCM_ConstString6_2[2].0
		siz		MP2L
		jmp		const6x8_strLoop
		inc		MP2H
		jmp		const6x8_strLoop
		ret
_LCM_ConstString6	endp
;-------------------------------------------------------------------------;
;void LCM_PutChar8(char val,u8 row,u8 col,u8 invt)
;-------------------------------------------------------------------------;
		public	_LCM_PutChar8
		public	_LCM_PutChar8_2
_LCM_PutChar8	proc
		local		_LCM_PutChar8_2	db 4 dup(?)		
		mov		_LCM_PutChar8_2[3],A
		;set position
		mov		A,_LCM_PutChar8_2[1]
		mov		LCMtmp0,A
		mov		A,_LCM_PutChar8_2[0]
		call		LCM8X8_position		
		;val * 8
		mov		A,_LCM_PutChar8_2[2]
		mov		LCMtmp1,A
		mov		A,_LCM_PutChar8_2[3]
		jmp		put8x8_block_data
		ret
_LCM_PutChar8	endp
;-------------------------------------------------------------------------;
;void LCM_PutString8(u8 *p,u8 row,u8 col,u8 invt)
;-------------------------------------------------------------------------;
		public	_LCM_PutString8
		public	_LCM_PutString8_2
_LCM_PutString8	proc
		local		_LCM_PutString8_2	db 5 dup(?)		
		;set position
		mov		A,_LCM_PutString8_2[3]
		mov		LCMtmp0,A
		mov		A,_LCM_PutString8_2[2]
		call		LCM8X8_position
		mov		A,_LCM_PutString8_2[0]
		mov		MP2L,A
		mov		A,_LCM_PutString8_2[1]
		mov		MP2H,A
		mov		A,_LCM_PutString8_2[4]
		mov		LCMtmp1,A
put8x8_strLoop:
		snz		IAR2
		ret
		mov		A,IAR2
		call		put8x8_block_data
		siz		MP2L
		jmp		put8x8_strLoop
		inc		MP2H
		jmp		put8x8_strLoop						
		ret
_LCM_PutString8	endp
;-------------------------------------------------------------------------;
;void LCM_ConstString8(uc8 *p,u8 row,u8 col,u8 invt)
;-------------------------------------------------------------------------;
		public	_LCM_ConstString8
		public	_LCM_ConstString8_2
_LCM_ConstString8	proc
		local		_LCM_ConstString8_2	db 5 dup(?)
		;set position
		mov		A,_LCM_ConstString8_2[3]
		mov		LCMtmp0,A
		mov		A,_LCM_ConstString8_2[2]
		call		LCM8X8_position
		mov		A,_LCM_ConstString8_2[0]
		mov		MP2L,A		
		mov		A,_LCM_ConstString8_2[1]
		mov		MP2H,A
		clr		_LCM_ConstString8_2[2].0
		snz		ACC.7
		jmp		$+7
		sz			_LCM_ConstString8_2[0].0
		set		_LCM_ConstString8_2[2].0
		rrc		MP2H
		rrc		MP2L
		mov		A,03FH
		andm		A,MP2H
		mov		A,_LCM_ConstString8_2[4]
		mov		LCMtmp1,A
const8x8_strLoop:
		mov		A,MP2L
		mov		TBLP,A
		mov		A,MP2H
		mov		TBHP,A
		TABRDC	MP1L
		mov		A,TBLH
		mov		MP1H,A
		sz			_LCM_ConstString8_2[2].0
		jmp		$+5
		snz		MP1L
		ret
		mov		A,MP1L
		call		put8x8_block_data		
		snz		MP1H
		ret
		mov		A,MP1H
		call		put8x8_block_data
		clr		_LCM_ConstString8_2[2].0		
		siz		MP2L
		jmp		const8x8_strLoop
		inc		MP2H
		jmp		const8x8_strLoop
		ret
_LCM_ConstString8	endp
;-------------------------------------------------------------------------;
;ACC = delay counter
;-------------------------------------------------------------------------;
LCM_delay	proc
		nop
		sdz		ACC
		jmp		$-2
		ret
LCM_delay	endp
;-------------------------------------------------------------------------;
;ACC = command
;-------------------------------------------------------------------------;
LCM_write_cmd	proc
		clr		LCMRS
;		set		SACSEN
		clr		LCMCSN
		mov		SPIAD,A
		mov		A,2
		sdz		ACC
		jmp		$-1
		jmp		$+1
;		clr		SACSEN
		set		LCMCSN
		set		LCMRS
		ret
LCM_write_cmd	endp
;-------------------------------------------------------------------------;
;ACC = rows
;LCMtmp0 = char columns
;-------------------------------------------------------------------------;
LCM6X8_position	proc
		mov		LCMtmp1,A
		mov		A,LCMtmp0
		rl			LCMtmp0				;*2
		rl			LCMtmp0				;*4
		addm		A,LCMtmp0
		addm		A,LCMtmp0			;*6
		mov		A,LCMtmp1
		jmp		LCM_set_position
LCM6X8_position	endp
;-------------------------------------------------------------------------;
;ACC = rows
;LCMtmp0 = char columns
;-------------------------------------------------------------------------;
LCM8X8_position	proc
		rl			LCMtmp0				;*2
		rl			LCMtmp0				;*4
		rl			LCMtmp0				;*8
		jmp		LCM_set_position
LCM8X8_position	endp
;-------------------------------------------------------------------------;
;ACC = rows
;LCMtmp0 = columns
;-------------------------------------------------------------------------;
LCM_set_position	proc
		clr		LCMRS
;		set		SACSEN
		and		A,00FH
		or			A,0B0H				;set page command
		clr		LCMCSN		
		mov		SPIAD,A
		mov		A,2
		sdz		ACC
		jmp		$-1
		swapa		LCMtmp0
		and		A,00FH
		or			A,010H				;set column address MSB		
		mov		SPIAD,A
		mov		A,2
		sdz		ACC
		jmp		$-1
		nop
		mov		A,LCMtmp0
		and		A,00FH				;set column address LSB
		mov		SPIAD,A
		mov		A,3
		sdz		ACC
		jmp		$-1
;		clr		SACSEN
		set		LCMCSN
		set		LCMRS
		ret
LCM_set_position	endp
;-------------------------------------------------------------------------;
;ACC = type
;LCMtmp0 = char
;-------------------------------------------------------------------------;
put6x8_block_data	proc
		mov		LCMtmp2,A
		clr		LCMtmp3
		clr		C
		rlc		LCMtmp2
		rlc		LCMtmp3			;*2
		addm		A,LCMtmp2
		clr		ACC
		adcm		A,LCMtmp3		;*3
		mov		A,LCMtmp2
		add		A,LOW(FONT6X8)
		mov		TBLP,A
		mov		A,HIGH(FONT6X8)		
		adc		A,LCMtmp3
		mov		TBHP,A
		mov		A,6/2
		mov		LCMtmp0,A
		jmp		LCM_DSP_start
put6x8_block_data	endp
;-------------------------------------------------------------------------;
;ACC = type
;LCMtmp0 = char
;-------------------------------------------------------------------------;
put8x8_block_data	proc
		mov		LCMtmp2,A
		clr		LCMtmp3
		clr		C
		rlc		LCMtmp2
		rlc		LCMtmp3			;*2
		clr		C
		rlc		LCMtmp2
		rlc		LCMtmp3			;*4
		mov		A,LCMtmp2
		add		A,LOW(FONT8X8)
		mov		TBLP,A
		mov		A,HIGH(FONT8X8)		
		adc		A,LCMtmp3
		mov		TBHP,A
		mov		A,8/2
		mov		LCMtmp0,A
		jmp		LCM_DSP_start
put8x8_block_data	endp
;-------------------------------------------------------------------------;
;ACC = type
;LCMtmp0 = data length
;TBHP:TBLP = data position
;-------------------------------------------------------------------------;
LCM_write_block_data	proc
		and		A,003H
		mov		LCMtmp1,A
LCM_DSP_start:		
		set		LCMRS
;		set		SACSEN
		clr		LCMCSN
      TABRDC	LCMtmp2		
LCM_DSP_loop:		
      mov		A,TBLH
      mov		LCMtmp3,A      
      mov		A,LCMtmp1
      addm		A,PCL
      public	LCM_DSP_TABLE
LCM_DSP_TABLE: 
      jmp		LCM_DSP_NORMAL
      jmp		LCM_DSP_INVERT
      jmp		LCM_DSP_CURSOR
      jmp		LCM_DSP_CLEAR		
LCM_DSP_INVERT:
		cpl		LCMtmp2
		cpl		LCMtmp3
		jmp		LCM_DSP_NORMAL
LCM_DSP_CURSOR:
		set		LCMtmp2.7
		set		LCMtmp3.7
		jmp		LCM_DSP_NORMAL
LCM_DSP_CLEAR:
		clr		LCMtmp2
		clr		LCMtmp3
LCM_DSP_NORMAL:
LCM_DSP_write:
		mov		A,LCMtmp2
		mov		SPIAD,A
		siz		TBLP
		jmp		$+2
		inc		TBHP
		nop
      TABRDC	LCMtmp2
		nop		
		mov		A,LCMtmp3
		mov		SPIAD,A
		sdz		LCMtmp0
		jmp		LCM_DSP_loop
		nop
		mov		A,2
		sdz		ACC
		jmp		$-1
;		clr		SACSEN
		set		LCMCSN
		ret
LCM_write_block_data	endp
;-------------------------------------------------------------------------;
		end